' ########################################################################################
' Microsoft Windows
' Contents: SAPI example
' Creates an instance of the ISpVoice interface, sets the the object of interest to word
' boundaries and sets the handle of the window that will receive the user-defined
' MSG_SAPI_EVENT message. When processing the MSG_SAPI_EVENT message, it calls the
' GetEvents method of the ISpVoice interface to retrieve the word boundaries and highlights
' the word in the edit control.
' Compiler: FreeBasic 32 & 64 bit
' Copyright (c) 2017 Jos Roca. Freeware. Use at your own risk.
' THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
' EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
' MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
' ########################################################################################

#define UNICODE
#INCLUDE ONCE "Afx/CWindow.inc"
#INCLUDE ONCE "Afx/AfxSapi.bi"

USING Afx

CONST IDC_START = 1001
CONST IDC_STOP = 1002
CONST IDC_TEXTBOX = 1003
CONST MSG_SAPI_EVENT = WM_USER + 1   ' --> change me

DECLARE FUNCTION WinMain (BYVAL hInstance AS HINSTANCE, _
                          BYVAL hPrevInstance AS HINSTANCE, _
                          BYVAL szCmdLine AS ZSTRING PTR, _
                          BYVAL nCmdShow AS LONG) AS LONG

   END WinMain(GetModuleHandleW(NULL), NULL, COMMAND(), SW_NORMAL)

' // Forward declaration
DECLARE FUNCTION WndProc (BYVAL hwnd AS HWND, BYVAL uMsg AS UINT, BYVAL wParam AS WPARAM, BYVAL lParam AS LPARAM) AS LRESULT

' ========================================================================================
' Main
' ========================================================================================
FUNCTION WinMain (BYVAL hInstance AS HINSTANCE, _
                  BYVAL hPrevInstance AS HINSTANCE, _
                  BYVAL szCmdLine AS ZSTRING PTR, _
                  BYVAL nCmdShow AS LONG) AS LONG

   ' // Set process DPI aware
   ' // The recommended way is to use a manifest file
   AfxSetProcessDPIAware

   ' // Initialize the COM library
   CoInitialize NULL

   ' // Creates the main window
   DIM pWindow AS CWindow
   ' -or- DIM pWindow AS CWindow = "MyClassName" (use the name that you wish)
   pWindow.Create(NULL, "SAPI example", @WndProc)
   ' // Sizes it by setting the wanted width and height of its client area
   pWindow.SetClientSize(1000, 700)
   ' // Centers the window
   pWindow.Center

   ' // Adds a button
   pWindow.AddControl("Button", , IDC_START, "StartREAD", 10, 0, 75, 23)
   pWindow.AddControl("Button", , IDC_STOP, "StopREAD", 85, 0, 75, 23)

   ' // Displays the window and dispatches the Windows messages
   FUNCTION = pWindow.DoEvents(nCmdShow)

   ' // Uninitialize the COM library
   CoUninitialize

END FUNCTION
' ========================================================================================

' ========================================================================================
' Main window procedure
' ========================================================================================
FUNCTION WndProc (BYVAL hwnd AS HWND, BYVAL uMsg AS UINT, BYVAL wParam AS WPARAM, BYVAL lParam AS LPARAM) AS LRESULT

   STATIC pSpVoice AS Afx_ISpVoice PTR, cwsText AS CWSTR

   SELECT CASE uMsg

      CASE WM_CREATE
         ' // Create an instance of the SpVoice object
         pSpVoice = AfxNewCom("SAPI.SpVoice")
         IF pSpVoice THEN
            ' // Set the object of interest to word boundaries
            pSpVoice->SetInterest(SPFEI(SPEI_WORD_BOUNDARY), SPFEI(SPEI_WORD_BOUNDARY))
            ' // Set the handle of the window that will receive the MSG_SAPI_EVENT message
            pSpVoice->SetNotifyWindowMessage(hwnd, MSG_SAPI_EVENT, 0, 0)
         END IF
         cwsText ="2025 september  : - Introducing   the  " & _ 
                     " ONE TWENTY FORTH OUT OF STEP/OUT OF PHASE, MECHANICAL  PRINCIPLE.    " & _        
    "( No abstract stuff here, this being a  hard-wired physical reality ) " & _  
    " A REAL Mechanical Geometric Relationship that is  1/24th Fractional, " & _ 
    " THAT COME  INTO EXISTENCE, WHEN ROTARY MOTION OCCUR between THE Common Square and an Ordinary Circle." & _	                                    
    " A  SQUARE.....	" & _						
    " with   All  corners   hinged   & " & _
    " with   one   hinge  acting  as  the  Top  corner  Pivot   to   which the Collapsible  Square  is " & _
    "connected / hanged,  and   thus  .....this being the  " & _
    "no.1 corner     link 	 " & _
    "as    numbered   from the  Top......  and it  is   a    Stationary  Pivot....... with    it's Opposing  " & _
    "no.3 corner     link  " & _
    "that   is ....Attached  to   the   Crank  Point    whose  ROTARY  TRACT  trace  then  represent " & _
    "A  CIRCLE....." & _
    "                     actually  a   Cranks Circle track , " & _
    "                      whose         Rotary  Centre  Point   " & _
    "                     is    at    a   fixed    Distance " & _
    "                     from  the     Stationary  Pivot  Point. " & _
    "                                                                                  " & _
    " THIS  CRANK   IS   THEN  'INDUCED'   TO   DO   THE  360 degree   ROTATION  " & _
    "(  Later more on this INDUCING  )" & _
    "The   2 FREE    Links of  the  Square that is Opposing,   is  then" & _
    " ( Clockwise ) numbered   no.2  &  no.4  on  either  side  of  the" & _
    " Vertical  which  geometric  abstract Vertical Line  is  between  the  " & _  
    "                    Pivot    Point  Centre   &   " & _
    "                   Crank   Rotary   Centre    Point.    " & _         
    "THUS  IN   A  SIMPLE  ARRANGEMENT. 	" & _
    "ADVANCING  ON .........A   REAL   Mechanical    Geometric   Relationship   that    is  " & _
    " 1/24th  Fractional," & _
    " NOW LETS MOVE ON TO .........		" & _					    
    "EXPECTATIONS  AND   ALSO  POSSIBLE APPLICATIONS......" & _
    " The  REASONABLE & USUAL, Geometric  Mathematical  EXPECTATION is " & _
    "that the plotted  Co-ordinates waveform  of  " & _
    " Link no.2" & _
    " as compared to the plotted Co-ordinates  waveform of	" & _
    "Link no.4  " & _
    " WOULD     BE      Just   an    EXACT Double MIRROR.....meaning   here  double = " & _
    " a   HORIZONTAL   &  a   VERTICAL  flip    OF    ONE WAVEFORMS  values as  in  the  case  of " & _
    "an ordinary  SEE Saws endpoints Plots." & _
    "          " & _
   " HOWEVER   this   USUAL   EXPECTATION   is    PROVEN    WRONG    in   THIS   case   of    the " & _
   "( SQUARE that is collapsible  CONNECTED   to   a   CIRCLE in Rotatory motion  )" & _
    "plot of Co-ordinates of Link no.2 compared to Link no.4 plot of  Co-ordinates  ......" & _
    "WHICH   ACTUALLY   RESOLVE   IN  PLOTS  WITH  WAVEFORMS   THAT   DO   NOT    MATCH,  " & _
    " by way of comparison  OF   THE   TWO    WAVE-SHAPES................. " & _
    " WHEN     ONE    WAVE    IS     HORIZONTALLY    &    VERTICALLY   FLIPPED    & " & _
    " PLACED    ON    TOP    OF    THE    OTHER    REMAINING    OPPOSITE    WAVE,    " & _
    " A  VISUAL OF  THESE  WAVES  THAT DO  NOT  FIT  ATOP  EACH  OTHER,   BECOMES   VERY    CLEAR. " & _
    "HOWEVER;-    MOVING   THE    ONE    WAVE    THEN  ONLY    BY   " & _
    " 1/24th    of    the    PLOTTED     Wavelength    ALONG    Its    VERTICAL    axis     will  " & _
    "resolve     in    a    TWIN-WAVE    Exact     FIT     OVER     23    parts     of     both      waves." & _
   " THIS  'TWIN-WAVE'  FIT   IS  A  GEOMETRIC  MANIPULATION   ONLY,   FOR  THE  PURPOSE OF " & _
    " THUS  PROVING THAT  THE   REAL  PHYSICAL   WAVES   IS    NATURALLY    ENTANGLED " & _
    "1/24th OUT OF STEP,  WHICH STATE IS EXPECTED TO GO DOWN TO THE QUANTUM LEVEL." & _
    "HARD-WIRED   &   'HIDING'   A   FINE  STRUCTURE 'RESOLVE'  IN PLAIN  SIGHT......more  on " & _
    "the    FINE   Structure   in    another   work,  since the 1/24th JUMPING in itself   is enough" & _
    "for  now.......since Some will note that it is called   JUMPING   deliberately  as  you  will spot " & _
    " that   on  360 degree  rotation ,   there  be  2  literal   Point instances , where    NO   OUT OF PHASE" & _
    "register....and    yet    the    very    next    Degree   of   advance   in   ROTATION    produce " & _
    " a  Jump   or   Tunnelling    into    a   jump   that   is   1/24th   of     OFF     the    Balance" & _
    "point that the  ebb  arrangement Just HAD At MAXIMUM and MININMUM  SQUARE FOLD  POSITIONS.   " & _
    " WHO ( OF RECENT TIMES )  KNEW  :- " & _
    "pi     COULD 'DO THAT'     " & _
    "IN    OUR EVERYDAY EXPERIENCE  ! 	" & _
    " OK : To   sum it   up   again......." & _
   "The  1/24th discovery  prove that  the   EXACT   REVERSE   &   MIRROR" & _
    "SEE-SAW    EXPECTATION    and    thus   ASSUMPTION   is     WRONG. 	" & _							
    " Remember :-" & _
    "THE DISCOVERY  is found by COMPARING" & _
    " the two sets of co-ordinates........    " & _								
    "SO THERE  is  ACTUALLY  an  OUT of  PHASE BETWEEN  THE  2 LINK'S  CO-ORDINATES " & _
    "of  EXACTLY  a   1/24th  of  a Phase/Step  DIFFERENCE in.............." & _
    " REAL HARD-WIRED MECHANICAL ACTION. 	" & _
    "						" & _
    " Now BEFORE COMMENTING ON  APPLICATION ...." & _
    "Lets start  a  little bit of 'vague'  history below :- " & _	
    " THIS THEN IS THE  1/24th OUT OF PHASE  DISCOVERY that  at  first    was taken as a  " & _
    " mere   visual    DISCREPANCY  due  to  a suspected    Mathematical  'ebb' - formula  " & _
    " mistake  or inaccuracy in the pi constant as used    in the  original  Q-Basic  programs " & _
    " since  the  Common  EXPECTATION   WAS that every co-ordinate will, See-saw like, do an " & _
    "Exact match  as calculated  with  its  corresponding  opposite  mirror values.    " & _
    " The REALITY, EVENTUALLY SPOTTED, However is that Link no.2  do NOT EXACT reverse " & _
    "mirror  / match the  opposing Link no. 4's   co-ordinate values,    but   rather    differ  " & _
    " by an OUT  Of Step or OUT of Phase  of exactly  1/24th." & _
    " Note about the  'ebb'  formula :- " & _
    " Initially   the   SUSPICION   regarding    the  Visual   DISCREPANCY     of    the " & _
    " 'ebb'-programs GRAPHIC OUTPUT, was  focused    on   the   Mathematical / Programmatic" & _
    "construction  since THE  'ebb'-program was aimed  at THE LOGIC OF  DETERMINING THE" & _
    "ACTUAL  CO-ORDINATES    of    the   Square    free     points / links    number 2    &      number  4 ." & _
    "         Originally   at  starting  off   to   write  the  'ebb'-program , some   bad   advise, " & _
    "        immediately  rejected ,  was well meaningly given circa 1997-99,  to just" & _
    "         guess  the  ebs Extension link  co-ordinates and working backwards" & _
    "        place /  use such  values into  the   'ebb'-program.    HOWEVER .............." & _
    "         APPLYING GUESSWORK  WOULD    HAVE    LEAD   TO  FAILURE  TO SPOT THE " & _
    "        1/24th OUT OF PHASENESS ,  THUS  A   REMAINING " & _
    "         HIDDEN to this author = m,    of      this  " & _
    "         SEVEN  STEP CORE  MATHEMATICAL  FORMULA  which 'ebb'  formula " & _
    "         Actually generate REAL  co-ordinates which in turn then REVEAL the " & _
    "         Visual   DISCREPANCY  that upon analysis off,  lead to the 1/24 Out of " & _
    "          Step IN  REALITY happening in a  HARD-WIRED MECHANICAL CONSTRUCTION." & _
    "         " & _
    " PHEW . ENOUGH EXPLAINING ABOVE.  " & _
    " SEE the 1/24out of phase principle   by running this FREEBASIC" & _
    "SOURCE-CODE....OR     THE    WINDOWS  exe   enjoy....SEE   FOR    YOURSELF." & _
    " NAMED :-            eb1_24=isStable           +             eb1_24=unStable " & _
    " WHOSE PURPOSE IS... 	" & _
    " EXAMINING The  importance   of   this   1/ 24 Fundamental  Principle regarding   our" & _
    " UNDERSTANDING OF : ...........................	" & _
    " 01  Physics ( quantum entanglement stuff Now and in another  program" & _
    "            Quantum jumping  which is  MORE ABOUT  spooky action = ;)  @ a distance  + " & _  
    "       a   fine structure  polarisation   plane resolve info,   as     revealed    by " & _
    "      a  Butterfly \ fold  Analytical reasoning conclusion, regarding the eb-arrangement etc. )" & _
    "        " & _
    "02  Mechanics ( the new  driving force  for an  electricity generation application )   and " & _
    " 	" & _			
   	"03  Biology ( protein forming speculations / proposals ),....is what this  program is all....." & _
   	"   " & _
 	"........about Demonstrating  , Theorising , Speculating. " & _
    "   " & _
    "Now continuing a little bit of 'vague'  history below :-	" & _
    "Thus named  ;- The eb:-   ( originally  a  new  type of  2 leg pendulum ), " & _
   "It was reinvented , way back, starting from circa  March of 1986.  The word REINVENTED" & _
   	" is fitting,  because the eb  later appeared to be at 1st glance ,  AS was POINTED OUT Circa " & _
   	" -+2000, to  be Similar to the Peaucellier / Lipkin,  LINKAGE which is a Straight line" & _
   	" generator of the late 1800s but with the directly opposite purpose that is :- the eb-linkage" & _
   	" is a Real CURVE Pendulum TRACK Generator." & _
   	" THIS WORK ONLY DEALS WITH THE TOP PART OF THE EB-pendulum, but the complete" & _
    "eb-formula is given in Source code. " & _
    " Thus a  re-discovery... i  guess,  that   took  my   slow  mind   about   17+ years  to" & _
    " NOTICE /  spot  the  1 / 24th   phase   difference,   that   is    from    MARCH    of    1986 " & _
    " up   to  the   8th  of  FEBRUARY  in    2004  when   the   penny" & _
   	"finally dropped upon STARING AT THE MOVING EB GRAPHIC WAVE PLOTS for months." & _
    " EVENTUALLY   UNDERSTANDING    CAME FLOODING  IN...... :) , AFTER A LOT OF HAND " & _
   	"DRAWING and CAD DRAWING  That finally PROVED  that the VISUAL  DISCREPANCY Was    " & _
    " REAL AND NO OBVIOUS FLAW EXISTED NOR WAS SPOTTED BY ADMITTEDLY A MATHS" & _
    "DABBLER  accustomed to suck from the lesser teat, regarding the domain of mathematics." & _
   	" " & _
   	" Then it took still   nearly    7 years to the month, till publication   by   the  date   " & _
    "17 February 2010   on   Wikipedia   under   the   name :    The 'Twine Sine' PRINCIPLE." & _
   	" SOON  THEREAFTER ,  THE  SAME YEAR ,  ON  MY  THEN  OWN  Web Site :-" & _
   	" junkyardinnovations.com	THE Eb info , was published , initially too complicated , " & _
   	" but  it was rebuilt / simplified  i hope,   in   2012  and later   renamed/ moved to....." & _
   	" https://junkyardinnovations.info 	" & _			     
   	" with  some major   updates over    the   years   especially in  2019    &    2023 + 2024 " & _
   	" and now this program meant for publication  in August+  2025." & _
    " NOW FOLLOWS  as in the SOURCE CODEs remarks / comments,  'Way below', yes  @ the" & _
    "bottom of  the source  code, an even  more Long-winded   detailed ,  explanation of    this programs........................" & _
   	"PURPOSE / APPLICATIONS." & _
    " 				" & _
   	"EVEN  THOSE  WHO  GETS  THE SQUARE + CIRCLE STUFF  @ THE  1st  TIME    AT THE TOP  , " & _
    "ARE ENCOURAGED TO READ THRU BELOW." & _							     
   	" WHAT IS  ADDED TO THE REPEAT OF THE 1/24th  INFO   IS  NOT  JUST FOR US WHO's" & _
   	"PERSONALITIES  ARE  INCLINED  TOWARDS A REPETITIVE  MANNER    SO AS TO" & _
    "GAIN  UNDERSTANDING, WITH SLIGHTLY DIFFERENT  ANGLED EXPLANATIONS AS" & _
   	" slanted from ABOVE, BUT  I  GUARANTEE YOU,   THERE  IS  NEW UNDERSTANDINGS" & _
    "AWAITING  IN  THE  SPECULATIONS    REGARDING  APPLICATIONS  OF THIS eb" & _
   	" 1/24.out.of.phase = 'eb124oop' :)    EB 'PENDULUM'   DISCOVERY." & _
   	"                " & _
    "158. Now follow  an  even   more LONG-WINDED  detailed ,  explanation  of  this " & _
  	"programs purpose  and possible applications. To Refresh your memory remember :  " & _
   	" This   program   is   about   the   'One   24th  Out   of    Phase'    OR    Out    of    Step" & _
    "Mechanical    Action     occurring    in   2  OPPOSING   free  CORNER    LINKS   of   a" & _
   	"Square     Simply    Connected    to     a        Crank     Circle,    during       Motion " & _
   	"of     the    EB    Pendulum's   PRIMARY Levers....  which is the Square + Crank Links." & _
   	"and WHY Knowledge of  This HARD-WIRED NEW MECHANICAL DISCOVERY,  " & _
   	" IS IMPORTANT." & _
    " NOW BRIEFLY FOLLOWS :-	" & _
    "Just some technical stuff 1st...............in order to run the *.bas,   Freebasic source files........ " & _
   	"WHEN USING THE SOURCE FILES :-" & _
   	"NOTE that  Paths given below is for EXAMPLE only :- " & _
   	" :-( also avoid spaces  in your file / directory names = Freebasic !) Avoid LIKE BELOW : -" & _
   	" C:\ PROGRAM FILES\ Compiler  Set-up = type  in  path  to  <lang FreeBasic>" & _
   	" RATHER DO :-   C:\FREEBASIC\ETC......" & _
   	" 				 						" & _
  	" NOTE THAT :-WinFBE_Suite 3.2.0 set up the compiler path  automaticly" & _
   	" upon unzipping WinFBE_Suite.zip in your chosen directory." & _
   	" 	" & _
   	" AGAIN :- See  Example paths below   for  WINDOWS Operating Systems :-	" & _
    "        " & _     							
    " C:\Free-basic\WinFBE_Suite\tool-chains\FreeBASIC-1.10.1-winlibs-gcc-9.3.0\fbc32.exe " & _
   	"OR" & _
   	" C:\FreeBasic\WinFBE_Suite\tool-chains\FreeBASIC-1.10.1-winlibs-gcc-9.3.0\fbc64.exe" & _
   	"      " & _
  	" ALSO an  Additional  compiler  option switch = type  in  only:-    -s gui " & _
    "       " & _
   	"SEE ALSO AFTER INSTALL :-	" & _							
    "C:\FreeBasic\WinFBE_Suite\Help\freebasic_manual.chm" & _
   	" " & _		
    " OPTIONAL :- ALSO INSTALL .................. C:\masm32\help\win32.chm" & _     
   	" (: if you want do the  GUI, the hard way :) " & _
    " " & _
    " SEE ALSO AFTER INSTALL :-" & _			
    " C:\FreeBasic\WinFBE_Suite\Help\WinFBE\Visual Designer\Controls " & _ 
    " " & _
    " Now Continuing  the even   more LONG-WINDED  detailed ,  explanation 	:-........" & _
   	" " & _
    " " & _
    " " & _
   	" 001......A hard-wired physical, 1/24th Out of Phase relationship," & _
   	"      recently  rediscovered,   REAL MECHANICAL  ACTION   that   occur" & _
   	"      between  the Elementary Circle   and the Common  Square   when the" & _
   	"      Circle acting as a rotating crank, is  connected  to  a  Square, whose  levers  is " & _
  	"      hinged at  the 4 corners  so  as  to  be  a  Collapsible Square." & _
  	"     " & _
   	"      " & _
   	"002......Pivoting One of the Squares corners  is  then  done and" & _
  	"    the One  corner hinge Opposing the Pivoted connection is  fixed," & _
   	"    but free to  turn,  on  the  Circle's  rotating Crank  endpoint. " & _
	"    That leave Two free Opposing corners on the  4 hinged LEVERED Square." & _
   	"      " & _		
    "      " & _			 								
   	" 003......Comparing these Two  Opposing  hinged Free  Corners  Motion" & _
   	"      Tracks is  what  lead to the  discovery  that  a   1/24th Out of" & _
   	"     Phase / Out of Step,   'jumping'    take  place  during  Rotation  of" & _
   	"      the Crank / Circle for most  of the  Circular  motion  with  the" & _
  	"      Exception being  when  the  Points where   Square is Minimum Folded and " & _
   	"     again where the  Square is  Maximum    Extended." & _
   	" 	 " & _
   	"    " & _				
  	" 004......This 1/ 24th Out of Step motion Difference between these" & _
 	"     Two opposing hinged free corners  positioned both sides ( of the" & _
   	"     Vertical line between Pivot & Circle centre ), motion tracks are more" & _
    "     easily  noticed by  the  human  eye  when  those tracks are parallel" & _
   	"     plotted to each  other on a grid and  only  one track    then flipped" & _
   	"     along  the  horizontal  and   that  same  track    then flipped again" & _
    "     on the vertical axis line so as to  compare    the Two tracks by" & _
    " Superimposing    or  Overlaying  on  each other." & _
    "             " & _
   	"005......The VERTICAL abstract  only used for geometric comparison construction Line" & _
   	"        mentioned is  referring here  to  the    line  between the Pivot Point  and  the Circle" & _
   	"        Rotary Centre,  which line  then  is  extended  unto the grid  as   it    will   serve    as " & _
    	"the   comparison  centre line. " & _
   	"      " & _			     					
     " 006......Upon Overlaying  the  now   Double  flipped,  expected Twin-wave  track generated" & _
      "    from  One  of the Squares free ends, It is noticed immediately that the  Waves are  not " & _
      "    fitting upon    each  other , but is slightly offset , that  being  a  offset gap   along" & _
       "  the 2 Waves full lengths of exactly  1/24th  of  the  total  Wavelength frequency," & _
       "   distance." & _	
    " 		" & _		 								
   " 007.......How so ? The how so, is answered when the  One  double flipped wave track is" & _
    "     moved / slided by the  distance equivalent to One Twenty Fourth of  the  distance  of" & _
    "      the  Total Wave  Grid   Wavelength track direction,  that  is along  or  parallel to the" & _
    "      VERTICAL  abstract  geometric   Line." & _
    "  " & _
    " 008......Only when this artificial Comparison action  of double    flipping and sliding by" & _
    "      1/24th for the purpose of such comparing    take place, do a partial exact match  occur" & _
   "      between  the 2 wave    Tracks meaning with One wave sticking off by 1/24th to the other " & _
    "     naturally opposing wave,   yet   THEN ONLY,   being exact Twin-waves to  each other" & _
    "      otherwise  along the remainder of the 2 waves tracks." & _
    "      " & _
   " 009......The  1/24  Out  of Step Discovery is  then proven  by a   Comparison action since" & _
   "       spotting  such  a motion difference with   the human eye will prove difficult if not" & _
  "       impossible taking also into account that   the UNINFORMED EXPECTATION is that the" & _
   "       Two Opposing free  points   behave  with   SEE-SAW  CONTRACTION ACTION only with" & _
    "       absolutely  NO  EXPECTATION  that  the Twin-waves will  jump out of Step  /  Phase" & _
    "       Between  when  the Square  is Minimum Folded an  for  that particular  EB's  Pendulum" & _
  "       Pivot Point  Distance to    Crank Centre." & _
   " " & _
    "  Phew ! !		" & _	
   " 010......The 1/24 Out of Step jump, is THE NATURAL STATE of this  pivoted,  hinged and in" & _
    "      rotary motion arrangement  that  occur  between the fixed rotation centre, Ordinary" & _
  "      Circle in rotation   and the  squeezable, hinged Common Square that is pivoted." & _
    "  " & _
 " 011......The  Main Foundational  Geometry  Discovery   of  this    mechanical  1/24 Out of" & _
"      Step jump refereed to as  the  EB pendulum, then leads to  for starters 2x  Additional " & _
  "     Foundational Discoveries    that  in   Geometry  exist  and  if  EB  THEORY  prove " & _
   "       correct,    will   impact    our    understanding   of    Physics. " & _
  "         " & _			 						
   "  012......1st Additional discovery is that :- A SINE-WAVE RESULTANT  exist  Between  the " & _
    "     Twin-waves  when  you    subtract offset   distances   from   each   other   as   taken" & _
    "     perpendicular from the Vertical Centre Line  unto the 1/24th OUT  OF PHASE 'TWIN" & _
     "    Wave tracks, the resultant being a perfect  Sine    wave structure that does  not" & _
  "      physically exist other than  as  a    Result between 2 points or  2 Particles  Intertwined " & _
    "      with  each  other in a Real / Physical , State of  being  quantum entangled, hence the" & _
   "     descriptive  name:- TWINE-SINE  refer  to  that result.    " & _
   "     This is COMPARABLE TO  Centre of MASS GEOMETRIC CALCULATION THAT ANY  ONE " & _
   "     OBJECT OR MANY IN A SYSTEM HAVE  BUT THIS  ABSTRACT POINT  ITSELF  DOES  NOT" & _
   "     NEED   TO FALL ON  A REAL PIECE OF THE MASS. " & _
   "   The manner of the Single Sinewave's  existence  is in Detection  of the 2 real " & _
    "     ENTANGLED  particles as  if it is  One  Sine  Wave    frequency  by our instruments,  while" & _
    "     the Shape of  the  Twin-waves    INFORMATION  that actually exist, may go unnoticed" & _
   "    UNNOTICED   U     say   ?   :) " & _
   "     WELL IMAGINE detecting/ seeing 2 EXACT SAME FREQUENCIES but then    being   able" & _
    "     to   detect their TWIN-WAVE  SHAPES   as  WELL.    NOW YOU MAY SEE THAT THOSE " & _
    "    TWIN-WAVE  SHAPES CAN CARRY POTENTIALLY   VASTLY DIFFERENT INFORMATION DUE" & _
    "    TO  THERE BEING A POSSIBILITY THAT    EVEN IF 2 FREQUENCIES IS SEEN AS EXACTLY THE" & _
   "     SAME, THEIR TWIN-WAVE    SHAPE-FORMS  MAY   DIFFER  in Shape  WHILE........" & _
   "     STILL  PRESENTING  ONE IDENTICAL = EXACT  SINE-WAVE RESULTANT FREQUENCY.	" & _
   "    PROPOSAL :-   " & _
    "     A Twin-wave Shape detector based on a thin Spiral roll of atoms acting as a  Printed" & _
 "    Circuit   CONNECTED to an Appropriately   Specialised    to   interpret   " & _
   "    TWIN-WAVES,   Microchip,  may help our understanding here Or perhaps many" & _
  "     detections  of  already observed particle reactions / identifications, really  should " & _
   "      be re-evaluated  from  the viewpoint/insights of Twin-waves. " & _
   "    	" & _					
    "  013......2nd Additional discovery is that :- " & _			
  "      VARYING SHAPES  of  Twin  Waves Appear when  generated after  an" & _
   "       Adjustment  in  Distance  between the  Pivot   and  the   Centre of  Circle  / CRANK.   " & _   
   "      That is one  single Static  adjustment  per  Crank  Rotation as opposed to a Dynamic" & _
   "      Constantly pulsed input. ( Thats  for later.....another work perhaps ;)    " & _ 
    "       A Minimum  and Maximum Distance exist between which a Variety  of Twin-wave " & _
   "       shapes, all them having a Random Wave , shaped like    a Soliton Form  which is  one" & _
   "        side  bunched  up in appearance,  " & _
    "        THERE IS 2 TYPES OF TWIN-WAVES= STABLE & UNSTABLE ( Prev. Called Elastic )" & _
    "        AS  U WILL SEE IN THE   eb-program." & _
    "        THEY ARE NOT RANDOM BUT RATHER  FUNDAMENTAL SHAPES not  derived    from " & _
    "         Fourier stuff but can be reproduced consistently by the EB-FORMULA. " & _
   "         Minimum is  the  Pivot point on the Circle Centre  position  and " & _
    "         Maximum  distance is a  Square fully Squeezed so  as to form a line due to    the" & _
    "          Maximum  Distance that   the  Circle  Centre  can be  from the  Pivot point without" & _
    "         breaking the EB system." & _
    "   			" & _     					 			
   "  014......NOTE that a  Change in Twin-wave Shape  does  NOT change  the  " & _
  "      Sine-wave   Resultant.		" & _				     
    "       It works somewhat like a reverse Fourier Transform." & _
 "       Always 2 Complex waves that can mathematically  Resolve=Present as a Single " & _
    "       Sine-wave.  Yes indeed a difficult way to make a Simple Sine-wave....." & _
   "                     " & _
    "  .........but  if  in nature such an Entangled Partnership BETWEEN PARTICLES IN  RADIATION" & _
   "          exist..Wow...what then !" & _
    " 								" & _
    " 015......Combining the  2 Additional s  then  bring  the Twin-wave    Twine-Sine " & _
   "       Theoretical points to the fore. " & _
   "                                 " & _
"         Introducing :-)  some    POSSIBILITIES / SPECULATIONS BELOW.  " & _
   "             (; in the form of very 'confidant' additional statements ;)" & _
    "  016......Particles in their NATURAL entangled state can  move as    " & _
   "       Twin-wave Patterns  of Greatly Varying Hidden, Shapes  that each  time present only " & _
  "        the  Sine-wave frequency Resultant to our crude    instruments  WHILE  CONTAINING" & _
  "        MUCH  MORE  UNDETECTED  TWIN-WAVE    INFORMATION     IN THEIR WAVE SHAPES." & _
  "                     " & _
  "  017......https://junkyardinnovations.info  Contain more Speculative stuff, with ideas on " & _
   "       things such as :-    Named Twin-wave  Shapes being of the form  that  present  as" & _
    "        COLD  LIGHT , while other named  Twin-waves  present  more  AS  HEAT  due   to " & _
    "       their  different  Twin-wave  Shapes  being   more   interactive when entering a " & _
   "       molecular lattice.    " & _
 "       Also there is a theory that may  lead  to  3D  Protein  printers,  related to  the " & _
    "       suspected  link  between Twin-wave  Shapes  and    Proteins molecules  3D Shape" & _
    "              forming,  and  those 2 thirds  of  the   so   called  missing Neutrino's  from the Sun. " & _
    "              I know that because of their  fleeting  interaction  with  other    matter,  nobody " & _
   "              would   see them as interacting with the  BIOMASS of Earth,  but then our detection  " & _
    "              ( Deep below Earth )  could  be  just the Leftover Type of Neutrinos whose Twin-wave" & _
    "               shape is  in    the   Pattern that pass thru easily such as i suspect  about  cold  lights " & _
    "             Twin-wave shapes.   WHAT would we see if it was possible to place  those   giant tanks " & _
  "             in  SPACE    and some directional method be found to  distinguish  the  other cosmic" & _
    "             ray particles  from   those neutrino's Originating  from    the  Sun  !" & _
    "              Even though the idea  of  neutrino  Twin-waves  interacting  with Amino Acids was" & _
    "             'approached' in my Twine Sine Song / Poem of 2010 as  published then :-........." & _
   "        ..........with line 12 stating.....on 		" & _
    "        https://junkyardinnovations.info    ;-" & _
   "        " & _
    "                                       Neutrinos emitted in twine form committed   	" & _	     
    "                                Forces proteins shape, glancing Hydrogen, admitted  " & _        
    "                                         Polarised selective through 360 degrees " & _
    "                                   Protein making align towards the Sun to please?" & _
   "        " & _
   "        THE FOLLOWING BEING MY QUESTION :-" & _
    "        I wonder if someone  picked this up  in  Experiment ?  SINCE 2010, that is by" & _
    "        Piping in seperate pipes the 20 used  Amino Acids  thru a   GYROSCOPE   that remain  pointed  to  the  Sun  AND at  a" & _
    "        central  micro point in the Gyro,  the  controlled / Sequential  adding  of    amino's  then " & _
    "        take  place  to create   a predetermined / computed,  3d string    with  the  full knowledge  of the " & _
    "        Twine-sine wave form from the Sun, FORCING what  a  then particular  Protein's Snap form" & _
    "        3d shape will be ultimately ,  as FORCED UNTO that Particular Amino String Sequences" & _
    "        AERIAL like  string PROFILE that it has for that brief moment Before  Snapping  into   lf's 3d" & _
    "        Protein shape fold structure." & _
    "        AT  Least such an experiment can help towards answering if the final 3d protein shape is " & _
   "        inherently / totally determined by  molecular stresses / forces along the initial string or" & _
    "        totally forced from outside or by a combination of outside  mixed with inside amino string" & _
    "         forces which last proposal is where my suspicion rest.  " & _
    "                        " & _
    "         It  is  not  only  Pharmacy,  that   could benefit   by  such  a    determination. " & _
    "         Imagine  being able to 3d Print  Proteins as FOODSTUFF or  Wood etc. directly?    Lets leave it at that.... " & _
    "                         " & _
    "                        " & _								
    "        And in Nov 2013 my Postulate no. 3,   hinted about the AMINO  string to Proteins folded, reason why,  directly again,  in" & _
    "        line ( i ) on   	the  main  page of ........" & _
    "                         " & _
    "        https://junkyardinnovations.info................  		" & _
    "                                          This relate to Protein forming" & _
    "                      regarding to  the  as yet      Mysterious  reason as  to  why  a" & _
    "                        Particular  String  of      Amino   Acids   would   Always  fold" & _
    "                     the  same   way   while it  really  Could   have   folded  into Many" & _
    "                                         other      Possible 3D  Combinations. " & _	
    "        	 It is  like  Dropping  a  Long  String  with  a  lot  of      Knots  in   it" & _
   "                          and   that  string  always, but   always     fall  into a  Heap  of" & _
    "                     3Dstring   that   is   always   3D  Shaped  exactly  the same, yes" & _
    "                                   every time  for that   Particular Combination 	" & _
    "                                                of  String Length   Knot  Type.  " & _ 
    "        " & _
    "        THE ABOVE POINT ABOUT AN UNANSWERED QUESTION IS TO MY LIMITED KNOWLEDGE" & _
    "        STILL TRUE as @ 2025 August." & _
   "        The  above  is  highlighted  so as  to  distinguish Twine-sine   Speculations as opposed to " & _
    "        the 'After the fact of  formation' analytical,   AI   Stuff of recent years regarding  " & _
    "        Protein Shapes.  " & _
    "         " & _		     
    "         TWINE-SINE  theory  hope  to understand  Every  time  how  that   'model car's'  CRASHED " & _
    "         3d shape would look like,   BEFORE the Crash  test." & _
    "         NOT THAT THERE IS NO NEED TO DO complex already there, Protein" & _
    "         shape 'UNTANGLING' so as to figure out the Original Amino Acid" & _
    "         String Sequence. 	" & _					     
    "        IF YOU ARE GOING TO COPY it, Manipulate it, you NEED that info,    " & _ 
    "        but knowing AHEAD OF ASSEMBLY, HOW TO  form  WHAT 3D  PROTEIN     GENERAL SHAPE" & _
    "        WILL APPEAR AND WITH WHAT AMINO STRING SEQUENCE WOULD  BE  VERY EMPOWERING, " & _
    "         if TWIN-WAVES can help. " & _
    "        " & _
    "        " & _
    "        " & _  		
    "        MOVING on to the  idea  of communicating / instructing  an Atom  with a language of" & _
    "        Twin-waves rather than ONLY smashing or fusing them with high energy." & _
    "         Not to forget the expansion of one  Single  frequency into many  channels  of  Twin-wave" & _
    "        data  carrying, in line  with  the  Many    Twin-wave Shapes that can be" & _
    "        packed into EVERY SINGLE  FREQUENCY.		" & _					
    "        The .info website however feature for now, mostly  the  Possible" & _
    "        utilisation  of the 1/24th HARD-WIRED  Imbalance  in  it's See-saw Like" & _
    "        Leverage Mechanical  action in the Square + Circle  of  the EB Pendulum  on  the Main page" & _
    "                       	" & _			
    "        This utilisation being proposed with a Fixed Continuous Squeezing  of the  1/24th out of" & _
    "        Step,  Hard-wired,  locked  in  Mechanical  MOMENT   Bubble of  Imbalance,  as" & _
    "         Illustrated  on  the  .info website's    Main page." & _
   "                  " & _
    "         Thus a  Continuous Static Moment FORCE  CONVERTED to Kinetic MOTION,  yes a pressure" & _
    "        to motion Conversion System." & _
    "        ROTARY MOTION ARISING from  A TORQUE  MOMENT SLIPPING  ON THE 124oop" & _
    "        BECOME A KINETIC = THUS IN MOTION SYSTEM for the benefit of POWER GENERATION." & _
    "        " & _
    "        Enjoy! your eb124 m to k device :" & _
    "        " & _
    "        THANKS to  ALL  Contributors to Freebasic and especially .....@" & _				
    "        https://github.com/PaulSquires/WinFBE/releases		" & _	     
    "         who greatly contributed to make this Freebasic  program possible and" & _
    "        with special note to :- nguyenc_chung      of" & _
    "         https://chungswebsite.blogspot.com/2010/09/guichung-easy-way-to-" & _
    "        make-gui-windows.html	" & _					     
   "        for making the GUI_stuff easy enough so as to fit within my" & _
    "        limited insights........me being Way too lazy/ scared to  hassle with the raw Win32api ;) " & _
    "        THE END........for now    ;)" & _
  "       "          
         
            
         DIM pWindow AS CWindow PTR = AfxCWindowPtr(lParam)
         IF pWindow THEN
            pWindow->AddControl("EditMultiline", hwnd, IDC_TEXTBOX, cwsText, 10, 22, 980, 1650, _
               WS_VISIBLE OR WS_TABSTOP OR WS_VSCROLL OR ES_LEFT OR ES_MULTILINE OR ES_NOHIDESEL OR ES_WANTRETURN)
         END IF
         EXIT FUNCTION

      CASE WM_COMMAND
         SELECT CASE GET_WM_COMMAND_ID(wParam, lParam)
            CASE IDCANCEL
               ' // If ESC key pressed, close the application by sending an WM_CLOSE message
               IF GET_WM_COMMAND_CMD(wParam, lParam) = BN_CLICKED THEN
                  SendMessageW hwnd, WM_CLOSE, 0, 0
                  EXIT FUNCTION
               END IF
            CASE IDC_START
               ' // Start speaking
               IF pSpVoice THEN pSpVoice->Speak(cwsText, SPF_ASYNC, NULL)
               EXIT FUNCTION
            CASE IDC_STOP
               ' // Stop speaking
               DIM cws AS CWSTR = ""
               IF pSpVoice THEN pSpVoice->Speak(cws, SVSFPurgeBeforeSpeak, NULL)
               EXIT FUNCTION
         END SELECT

      CASE MSG_SAPI_EVENT
         DIM eventItem AS SPEVENT, eventStatus AS SPVOICESTATUS
         DO
            IF pSpVoice->GetEvents(1, @eventItem, NULL) <> S_OK THEN EXIT DO
            IF eventItem.eEventId = SPEI_WORD_BOUNDARY THEN
               pSpVoice->GetStatus(@eventStatus, NULL)
               DIM nStart AS LONG = eventStatus.ulInputWordPos
               DIM nLen AS LONG = eventStatus.ulInputWordLen
               Edit_SetSel(GetDlgItem(hwnd, IDC_TEXTBOX), nStart, nStart + nLen)
            END IF
         LOOP
    	CASE WM_DESTROY
          ' // Release the ISpVoice interface
         AfxSafeRelease(pSpVoice)
         ' // Ends the application by sending a WM_QUIT message
         PostQuitMessage(0)
         EXIT FUNCTION

   END SELECT

   ' // Default processing of Windows messages
   FUNCTION = DefWindowProcW(hwnd, uMsg, wParam, lParam)

END FUNCTION
' ========================================================================================
